<?php
// Version: 1.1; index

/*	This template is, perhaps, the most important template in the theme. It
	contains the main template layer that displays the header and footer of
	the forum, namely with main_above and main_below. It also contains the
	menu sub template, which appropriately displays the menu; the init sub
	template, which is there to set the theme up; (init can be missing.) and
	the linktree sub template, which sorts out the link tree.

	The init sub template should load any data and set any hardcoded options.

	The main_above sub template is what is shown above the main content, and
	should contain anything that should be shown up there.

	The main_below sub template, conversely, is shown after the main content.
	It should probably contain the copyright statement and some other things.

	The linktree sub template should display the link tree, using the data
	in the $context['linktree'] variable.

	The menu sub template should display all the relevant buttons the user
	wants and or needs.

	For more information on the templating system, please see the site at:
	http://www.simplemachines.org/
*/

// Initialize the template... mainly little settings.
function template_init()
{
	global $context, $settings, $options, $txt;

	/* Use images from default theme when using templates from the default theme?
		if this is 'always', images from the default theme will be used.
		if this is 'defaults', images from the default theme will only be used with default templates.
		if this is 'never' or isn't set at all, images from the default theme will not be used. */
	$settings['use_default_images'] = 'never';

	/* What document type definition is being used? (for font size and other issues.)
		'xhtml' for an XHTML 1.0 document type definition.
		'html' for an HTML 4.01 document type definition. */
	$settings['doctype'] = 'xhtml';

	/* The version this template/theme is for.
		This should probably be the version of SMF it was created for. */
	$settings['theme_version'] = '1.1';

	/* Set a setting that tells the theme that it can render the tabs. */
	$settings['use_tabs'] = true;

	/* Use plain buttons - as oppossed to text buttons? */
	$settings['use_buttons'] = true;

	/* Show sticky and lock status seperate from topic icons? */
	$settings['seperate_sticky_lock'] = true;

	/* Call to Theme String for languages  */
	if (loadlanguage('ThemeStrings') == false)
	loadLanguage('ThemeStrings', 'english');

}

// The main sub template above the content.
function template_main_above()
{
	global $context, $settings, $options, $scripturl, $txt, $modSettings;

	// Show right to left and the character set for ease of translating.
	echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml"', $context['right_to_left'] ? ' dir="rtl"' : '', '><head>
	<meta http-equiv="Content-Type" content="text/html; charset=', $context['character_set'], '" />
	<meta name="description" content="', $context['page_title'], '" />', empty($context['robot_no_index']) ? '' : '
	<meta name="robots" content="noindex" />', '
	<meta name="keywords" content="PHP, MySQL, bulletin, board, free, open, source, smf, simple, machines, forum" />
	<script language="JavaScript" type="text/javascript" src="', $settings['default_theme_url'], '/script.js?fin11"></script>
	<script language="JavaScript" type="text/javascript"><!-- // --><![CDATA[
		var smf_theme_url = "', $settings['theme_url'], '";
		var smf_images_url = "', $settings['images_url'], '";
		var smf_scripturl = "', $scripturl, '";
		var smf_iso_case_folding = ', $context['server']['iso_case_folding'] ? 'true' : 'false', ';
		var smf_charset = "', $context['character_set'], '";
	// ]]></script>
	<title>', $context['page_title'], '</title>';

	// The ?fin11 part of this link is just here to make sure browsers don't cache it wrongly.
	echo '
	<link rel="stylesheet" type="text/css" href="', $settings['theme_url'], '/style.css?fin11" />
	<link rel="stylesheet" type="text/css" href="', $settings['default_theme_url'], '/print.css?fin11" media="print" />';

	/* Internet Explorer 4/5 and Opera 6 just don't do font sizes properly. (they are big...)
		Thus, in Internet Explorer 4, 5, and Opera 6 this will show fonts one size smaller than usual.
		Note that this is affected by whether IE 6 is in standards compliance mode.. if not, it will also be big.
		Standards compliance mode happens when you use xhtml... */
	if ($context['browser']['needs_size_fix'])
		echo '
	<link rel="stylesheet" type="text/css" href="', $settings['default_theme_url'], '/fonts-compat.css" />';

	// Show all the relative links, such as help, search, contents, and the like.
	echo '
	<link rel="help" href="', $scripturl, '?action=help" target="_blank" />
	<link rel="search" href="' . $scripturl . '?action=search" />
	<link rel="contents" href="', $scripturl, '" />';

	// If RSS feeds are enabled, advertise the presence of one.
	if (!empty($modSettings['xmlnews_enable']))
		echo '
	<link rel="alternate" type="application/rss+xml" title="', $context['forum_name'], ' - RSS" href="', $scripturl, '?type=rss;action=.xml" />';

	// If we're viewing a topic, these should be the previous and next topics, respectively.
	if (!empty($context['current_topic']))
		echo '
	<link rel="prev" href="', $scripturl, '?topic=', $context['current_topic'], '.0;prev_next=prev" />
	<link rel="next" href="', $scripturl, '?topic=', $context['current_topic'], '.0;prev_next=next" />';

	// If we're in a board, or a topic for that matter, the index will be the board's index.
	if (!empty($context['current_board']))
		echo '
	<link rel="index" href="' . $scripturl . '?board=' . $context['current_board'] . '.0" />';

	// We'll have to use the cookie to remember the header...
	if ($context['user']['is_guest'])
		$options['collapse_header'] = !empty($_COOKIE['upshrink']);

	// Output any remaining HTML headers. (from mods, maybe?)
	echo $context['html_headers'], '

	<script language="JavaScript" type="text/javascript"><!-- // --><![CDATA[
		var current_header = ', empty($options['collapse_header']) ? 'false' : 'true', ';

		function shrinkHeader(mode)
		{';

	// Guests don't have theme options!!
	if ($context['user']['is_guest'])
		echo '
			document.cookie = "upshrink=" + (mode ? 1 : 0);';
	else
		echo '
			smf_setThemeOption("collapse_header", mode ? 1 : 0, null, "', $context['session_id'], '");';

	echo '
			document.getElementById("upshrink").src = smf_images_url + (mode ? "/upshrink2.gif" : "/upshrink.gif");

			document.getElementById("upshrinkHeader").style.display = mode ? "none" : "";
			document.getElementById("upshrinkHeader2").style.display = mode ? "none" : "";

			current_header = mode;
		}
	// ]]></script>';

	// the routine for the info center upshrink
	echo '
		<script language="JavaScript" type="text/javascript"><!-- // --><![CDATA[
			var current_header_ic = ', empty($options['collapse_header_ic']) ? 'false' : 'true', ';

			function shrinkHeaderIC(mode)
			{';

	if ($context['user']['is_guest'])
		echo '
				document.cookie = "upshrinkIC=" + (mode ? 1 : 0);';
	else
		echo '
				smf_setThemeOption("collapse_header_ic", mode ? 1 : 0, null, "', $context['session_id'], '");';

	echo '
				document.getElementById("upshrink_ic").src = smf_images_url + (mode ? "/expand.gif" : "/collapse.gif");

				document.getElementById("upshrinkHeaderIC").style.display = mode ? "none" : "";

				current_header_ic = mode;
			}
		// ]]></script>

</head>
<body>
	<div id="body-top">
		<div id="top-banner">
			<div id="userarea" class="smalltext">
			<span class="time">' , $context['current_time'], '</span><br />';
				if($context['user']['is_logged'])
				{
					echo $txt['hello_member_ndt'] , ' <strong>' , $context['user']['name'] , '</strong><br />';

					// Only tell them about their messages if they can read their messages!
					if ($context['allow_pm'])
						echo '&nbsp;&nbsp;[<a href="', $scripturl, '?action=pm">', $context['user']['messages'], '/<strong>', $context['user']['unread_messages'] , '</strong></a> ', $txt['pm'], ']';

					// Is the forum in maintenance mode?
					if ($context['in_maintenance'] && $context['user']['is_admin'])
						echo '[<strong>', $txt['maintenance'], '</strong>]';

					// Are there any members waiting for approval?
						if (!empty($context['unapproved_members']))
						echo '[<a href="', $scripturl, '?action=viewmembers;sa=browse;type=approve">', $context['unapproved_members'] , '', $txt['approve'], '</a> ]';

						echo '
							<a href="', $scripturl, '?action=unread">', $txt['unread'], '</a> |
							<a href="', $scripturl, '?action=unreadreplies">', $txt[110], '</a>';
				}
				// Otherwise they're a guest - this time ask them to either register or login - lazy bums...
				else
				{
				echo '				
			<script language="JavaScript" type="text/javascript" src="', $settings['default_theme_url'], '/sha1.js"></script>
				<form action="', $scripturl, '?action=login2" method="post" accept-charset="', $context['character_set'], '" ', empty($context['disable_login_hashing']) ? ' onsubmit="hashLoginPassword(this, \'' . $context['session_id'] . '\');"' : '', '>
					<input class="loginput" type="text" name="user" size="10" />
					<input class="loginput" type="password" name="passwrd" size="10" /><br />
					<input class="logbutton" type="submit" value="', $txt[34], '" />
					<input type="hidden" name="hash_passwrd" value="" />
				</form>';
				}
		echo '
			</div>
			<div id="logo">
				<a href="'.$scripturl.'" title=""></a>
			</div>
		</div>
	</div>
	<div id="mainbody">
		<div class="wrapper">
			<div id="toolbar">
				',template_menu(),'
			</div>
				<div class="clr"/>
			<div id="bodyarea">';

}

function template_main_below()
{
	global $context, $settings, $options, $scripturl, $txt;

	echo '
			</div>
		</div>
	</div>';

	// Show the "Powered by" and "Valid" logos, as well as the copyright. Remember, the copyright must be somewhere!
	echo '
		<div id="footer">
			<div id="copywrte">
				<span class="smalltext">', theme_copyright(), '<br />
					<strong>X-Mas</strong> design by <a href="http://www.dzinerstudio.com" target="_blank">DzinerStudio</a></span>';

				// Show the load time?
				if ($context['show_load_time'])
				echo '<br />
					<span class="smalltext">', $txt['smf301'], $context['load_time'], $txt['smf302'], $context['load_queries'], $txt['smf302b'], '</span>';

		echo '
			</div>
		</div>';

echo '
</body></html>';
}

// Show a linktree. This is that thing that shows "My Community | General Category | General Discussion"..
function theme_linktree()
{
	global $context, $settings, $options;

	echo '<div class="pathway">';

	// Each tree item has a URL and name. Some may have extra_before and extra_after.
	foreach ($context['linktree'] as $link_num => $tree)
	{
		// Show something before the link?
		if (isset($tree['extra_before']))
			echo $tree['extra_before'];

		// Show the link, including a URL if it should have one.
		echo '<b>', $settings['linktree_link'] && isset($tree['url']) ? '<a href="' . $tree['url'] . '"	class="nav">' . $tree['name'] . '</a>' : $tree['name'], '</b>';

		// Show something after the link...?
		if (isset($tree['extra_after']))
			echo $tree['extra_after'];

		// Don't show a separator for the last one.
		if ($link_num != count($context['linktree']) - 1)
			echo '&nbsp;>&nbsp;';
	}

	echo '</div>';
}

// Show the menu up top. Something like [home] [help] [profile] [logout]...
function template_menu()
{
	global $context, $settings, $options, $scripturl, $txt;

	// Work out where we currently are.
	$current_action = 'home';
	if (in_array($context['current_action'], array('admin', 'managegames', 'arcadesettings', 'arcadecategory', 'ban', 'boardrecount', 'cleanperms', 'detailedversion', 'dumpdb', 'featuresettings', 'featuresettings2', 'findmember', 'maintain', 'manageattachments', 'manageboards', 'managecalendar', 'managesearch', 'membergroups', 'modlog', 'news', 'optimizetables', 'packageget', 'packages', 'permissions', 'pgdownload', 'postsettings', 'regcenter', 'repairboards', 'reports', 'serversettings', 'serversettings2', 'smileys', 'viewErrorLog', 'viewmembers')))
		$current_action = 'admin';
	if (in_array($context['current_action'], array('search', 'admin', 'calendar', 'profile', 'mlist', 'register', 'login', 'help', 'pm', 'forum')))
		$current_action = $context['current_action'];
	if ($context['current_action'] == 'search2')
		$current_action = 'search';
	if ($context['current_action'] == 'theme')
		$current_action = isset($_REQUEST['sa']) && $_REQUEST['sa'] == 'pick' ? 'profile' : 'admin';

	if (isset($_GET['board']) || isset($_GET['topic']) || $context['current_action']=='forum')
		$current_action = 'forum';

	// Are we using right-to-left orientation?
	if ($context['right_to_left'])
	{
		$first = 'last';
		$last = 'first';
	}
	else
	{
		$first = 'first';
		$last = 'last';
	}

	// Show the start of the tab section.
	echo '
		<div id="topmenu">
			<ul>';
			
				// Show the [home] button.
				echo '<li><a' , $current_action=='home' ? ' class="current"' : '' , ' href="', $scripturl, '"><span>' , $txt[103] , '</span></a></li>';

				// Show the [help] button.
				echo '<li><a' , $current_action=='help' ? ' class="current"' : '' , ' href="', $scripturl, '?action=help"><span>' , $txt[119] , '</span></a></li>';

				// How about the [search] button?
				if ($context['allow_search'])
				echo '<li><a' , $current_action=='search' ? ' class="current"' : '' , ' href="', $scripturl, '?action=search"><span>' , $txt[182] , '</span></a></li>';

				// The [calendar]!
				if ($context['allow_calendar'])
				echo '<li><a' , $current_action=='calendar' ? ' class="current"' : '' , ' href="', $scripturl, '?action=calendar"><span>' , $txt['calendar24'] , '</span></a></li>';
				
				// Is the user allowed to administrate at all? ([admin])
				if ($context['allow_admin'])
				echo '<li><a' , $current_action=='admin' ? ' class="current"' : '' , ' href="', $scripturl, '?action=admin"><span>' , $txt[2] , '</span></a></li>';

				// Edit Profile... [profile]
				if ($context['allow_edit_profile'])
				echo '<li><a' , $current_action=='profile' ? ' class="current"' : '' , ' href="', $scripturl, '?action=profile"><span>' , $txt[79] , '</span></a></li>';

				// Go to PM center... [pm]
				if ($context['user']['is_logged'] && $context['allow_pm'])
				echo '<li><a' , $current_action=='pm' ? ' class="current"' : '' , ' href="', $scripturl, '?action=pm"><span>' , $txt['pm_short'] , ' ', $context['user']['unread_messages'] > 0 ? '[<strong>'. $context['user']['unread_messages'] . '</strong>]' : '' , '</span></a></li>';

				// the [member] list button
				if ($context['allow_memberlist'])
				echo '<li><a ' , $current_action=='mlist' ? ' class="current"' : '' , ' href="', $scripturl, '?action=mlist"><span>' , $txt[331] , '</span></a></li>';

				// If the user is a guest, show [login] button.
	 			if ($context['user']['is_guest'])
				echo '<li><a ' , $current_action=='login' ? ' class="current"' : '' , ' href="', $scripturl, '?action=login"><span>' , $txt[34] , '</span></a></li>';

				// If the user is a guest, also show [register] button.
				if ($context['user']['is_guest'])
				echo '<li><a ' , $current_action=='register' ? ' class="current"' : '' , ' href="', $scripturl, '?action=register"><span>' , $txt[97] , '</span></a></li>';

				// Otherwise, they might want to [logout]...
				if ($context['user']['is_logged'])
				echo '<li><a ' , $current_action=='logout' ? ' class="current"' : '' , 'href="', $scripturl, '?action=logout;sesc=', $context['session_id'], '"><span>' , $txt[108] , '</span></a></li>';

		echo '
			</ul>
		</div>';

}

// Generate a strip of buttons.
function template_button_strip($button_strip, $direction = 'top', $force_reset = false, $custom_td = '')
{
	global $settings, $buttons, $context, $txt, $scripturl;

	// Create the buttons...
	foreach ($button_strip as $key => $value)
	{
		if (isset($value['test']) && empty($context[$value['test']]))
		{
			unset($button_strip[$key]);
			continue;
		}
		elseif (!isset($buttons[$key]) || $force_reset)
			$buttons[$key] = '<a href="' . $value['url'] . '" ' .( isset($value['custom']) ? $value['custom'] : '') . '>' . $txt[$value['text']] . '</a>';

		$button_strip[$key] = $buttons[$key];
	}

	if (empty($button_strip))
		return '<td>&nbsp;</td>';

	echo '
		<td class="', $direction == 'top' ? 'main' : 'mirror', 'tab_' , $context['right_to_left'] ? 'last' : 'first' , '">&nbsp;</td>
		<td class="', $direction == 'top' ? 'main' : 'mirror', 'tab_back">', implode(' &nbsp;|&nbsp; ', $button_strip) , '</td>
		<td class="', $direction == 'top' ? 'main' : 'mirror', 'tab_' , $context['right_to_left'] ? 'first' : 'last' , '">&nbsp;</td>';
}

?>